/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.TextTableAnd3ButtonGroupDataBean;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFruFilter;
import com.ibm.hwmca.xfw.service.panel.PBCommonInfoCenterIsolateSelect;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery10;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery20;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery30;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery40;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery50;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery60;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery70;
import com.ibm.ui.framework.ItemDescriptor;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class PIDriveInfoCenterIsolate
implements Effector {
    private static final String TRACE_MASKT = "XRVPICIT";
    private static final String TRACE_MASKF = "XRVPICIF";
    private static final String TRACE_MASKD = "XRVPICID";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fire(Context context) throws EffectorException {
        Iterator it3222;
        Trace.trace(TRACE_MASKT, "-> PIDriveInfoCenterIsolate.fire");
        Map userData = context.getUserData();
        List fruList = (List)userData.get("SELECTED_FRUS");
        ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
        ArrayList<ServiceableElement> completedIsolates = new ArrayList<ServiceableElement>();
        try {
            try {
                String hmcIPAddress;
                ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
                if (edaf == null) {
                    Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterIsolate.fire ExternalDataAccessFactory not set in userData");
                    throw new EffectorException("ExternalDataAccessFactory not set in userData");
                }
                HashMap<String, Object> hmFruInfo = new HashMap<String, Object>();
                PBCommonInfoCenterIsolateSelect isolateSelectPB = new PBCommonInfoCenterIsolateSelect();
                PBCommonPostInfoCenterIsolateQuery10 isolateQuery10PB = new PBCommonPostInfoCenterIsolateQuery10();
                PBCommonPostInfoCenterIsolateQuery20 isolateQuery20PB = new PBCommonPostInfoCenterIsolateQuery20();
                PBCommonPostInfoCenterIsolateQuery50 isolateQuery50PB = new PBCommonPostInfoCenterIsolateQuery50();
                GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                Locale clientLocale = Locale.US;
                try {
                    hmcIPAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "PIDriveInfoCenterIsolate.fire exception caught getting hmc ip addres; using 127.0.0.1");
                    hmcIPAddress = "127.0.0.1";
                }
                boolean delayed = false;
                boolean problemIsFixed = false;
                Iterator it2 = fruList.iterator();
                while (it2.hasNext()) {
                    int fruFlagValue;
                    ServiceableElement se = (ServiceableElement)it2.next();
                    int n = fruFlagValue = se.getProperty("FLAGS") == null ? 1 : (Integer)se.getProperty("FLAGS");
                    if (fruFlagValue != 4) {
                        Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire non-isolate FRU detected in selected list... ignoring.  Fru Location: " + se.getProperty("LOCATION"));
                        continue;
                    }
                    hmFruInfo.clear();
                    isolateSelectPB.setDataMap(hmFruInfo);
                    isolateQuery10PB.setDataMap(hmFruInfo);
                    isolateQuery20PB.setDataMap(hmFruInfo);
                    isolateQuery50PB.setDataMap(hmFruInfo);
                    ExternalDataAccess eda = edaf.create(null);
                    hmFruInfo.put("EXTERNAL_DATA_ACCESS", eda);
                    hmFruInfo.put("HMC_HOSTNAME", hmcIPAddress);
                    eda.setToken((Serializable)((Object)this.makeInfoCenterURL((String)se.getProperty("PART_NUM"), hmcIPAddress, clientLocale)));
                    isolateSelectPB = (PBCommonInfoCenterIsolateSelect)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", isolateSelectPB.getTemplateName(), isolateSelectPB, userData);
                    if (isolateSelectPB.isSecondRadioButtonSelected()) {
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                        context.getVariable(SD.ISOLATE_STATUS_VARIABLE).setValue(SD.DEFINED_NOT_RUN);
                        delayed = true;
                        Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire Delay selected during ISOLATE processing... setting OVERALL_STATUS to delay");
                        break;
                    }
                    if ((isolateQuery10PB = (PBCommonPostInfoCenterIsolateQuery10)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", isolateQuery10PB.getTemplateName(), isolateQuery10PB, userData)).isFirstRadioButtonSelected()) {
                        problemIsFixed = true;
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.CLOSE_PROBLEMS);
                        Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire Problem FIXED during ISOLATE processing... setting OVERALL_STATUS to CLOSE_PROBLEMS");
                    } else if (isolateQuery10PB.isThirdRadioButtonSelected()) {
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                        context.getVariable(SD.ISOLATE_STATUS_VARIABLE).setValue(SD.DEFINED_NOT_RUN);
                        delayed = true;
                        Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire Delay selected during ISOLATE processing... setting OVERALL_STATUS to delay");
                        break;
                    }
                    completedIsolates.add(se);
                    context.getVariable(SD.ISOLATE_STATUS_VARIABLE).setValue(SD.DEFINED_RAN);
                    Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire ISOLATE ran... setting ISOLATE_STATUS=DEFINED_RAN");
                    isolateQuery20PB = (PBCommonPostInfoCenterIsolateQuery20)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", isolateQuery20PB.getTemplateName(), isolateQuery20PB, userData);
                    if (isolateQuery20PB.isFirstRadioButtonSelected()) {
                        this.selectExchangedOrFailingFrus(true, userData, guiHandle);
                    }
                    if (problemIsFixed) break;
                    if ((isolateQuery50PB = (PBCommonPostInfoCenterIsolateQuery50)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", isolateQuery50PB.getTemplateName(), isolateQuery50PB, userData)).isSecondRadioButtonSelected()) {
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.SWITCH_FRUS);
                        context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.EXIT);
                        Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.fire ISOLATE ran - problem NOT isolate.  Setting OVERALL_STATUS=SWITCH_FRUS");
                        break;
                    }
                    this.selectExchangedOrFailingFrus(false, userData, guiHandle);
                    context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.SELECTED);
                    context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.EXIT);
                    Trace.trace(TRACE_MASKD, "Problem isolated.");
                    Trace.trace(TRACE_MASKD, "SD.FRU_SELECTION_STATUS_VARIABLE set to " + SD.SELECTED);
                }
                Object var22_23 = null;
                it3222 = completedIsolates.iterator();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterIsolate.displayServiceEffect exception caught: " + e);
                Trace.trace(TRACE_MASKT, e);
                throw new EffectorException(e);
            }
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            Iterator it3222 = completedIsolates.iterator();
            while (true) {
                if (!it3222.hasNext()) {
                    throw throwable;
                }
                fruList.remove(it3222.next());
            }
        }
        while (true) {
            if (!it3222.hasNext()) {
                Trace.trace(TRACE_MASKT, "< PIDriveInfoCenterIsolate.displayServiceEffect");
                return;
            }
            fruList.remove(it3222.next());
        }
    }

    void selectExchangedOrFailingFrus(boolean isExchange, Map userData, GenericGui guiHandle) throws EffectorException {
        Vector<Object> vRow = new Vector<Object>();
        Vector<Vector<Object>> vRowData = new Vector<Vector<Object>>();
        List fruList = (List)userData.get("FRU_LIST");
        try {
            if (fruList.isEmpty()) {
                throw new Exception("FRU list is empty.");
            }
            Iterator fruListIter = fruList.iterator();
            while (fruListIter.hasNext()) {
                Fru fruInList = (Fru)fruListIter.next();
                String sFruLoc = (String)fruInList.getProperty("LOCATION");
                int sfxStartIndex = sFruLoc.indexOf(45) + 1;
                int sfxEndIndex = sFruLoc.length();
                String sFruLocSfx = sFruLoc.substring(sfxStartIndex, sfxEndIndex);
                vRow.clear();
                vRow.add(sFruLocSfx);
                vRow.add(fruInList.getProperty("DESC"));
                vRow.add(fruInList.getProperty("ENCLOSURE_TYPE"));
                vRow.add(fruInList.getProperty("ENCLOSURE_MODEL"));
                vRow.add(fruInList.getProperty("ENCLOSURE_SERIAL"));
                vRowData.add(vRow);
            }
            CommonDataBean pb = isExchange ? new PBCommonPostInfoCenterIsolateQuery30(new Vector(), vRowData) : new PBCommonPostInfoCenterIsolateQuery60(new Vector(), vRowData);
            String sSelRadBut = ((TextTableAnd3ButtonGroupDataBean)(pb = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pb.getTemplateName(), pb, userData))).getButtongroupSelection()[0];
            if (sSelRadBut.equals("RadioButton1")) {
                vRowData.clear();
                int[] aiNextSelected = null;
                this.getFruTableData(vRowData, fruList, (TextTableAnd3ButtonGroupDataBean)pb, aiNextSelected);
                pb = isExchange ? new PBCommonPostInfoCenterIsolateQuery40(new Vector(), vRowData) : new PBCommonPostInfoCenterIsolateQuery70(new Vector(), vRowData);
                ((TextTableAnd3ButtonGroupDataBean)pb).setFruTableSelection(aiNextSelected);
                pb = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pb.getTemplateName(), pb, userData);
                while (pb.getElementName().equals("ButtonFRUDetails")) {
                    ((TextTableAnd3ButtonGroupDataBean)pb).setFruTableSelection(aiNextSelected);
                    pb = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pb.getTemplateName(), pb, userData);
                }
                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                CommonProblem problem = (CommonProblem)userData.get("PROBLEM");
                if (isExchange) {
                    this.addNewFrus((TextTableAnd3ButtonGroupDataBean)pb, fruList, ms, problem, true);
                } else {
                    this.addNewFrus((TextTableAnd3ButtonGroupDataBean)pb, fruList, ms, problem, false);
                }
            }
            int[] aiPrevSelected = ((TextTableAnd3ButtonGroupDataBean)pb).getFruTableSelection();
            block4: for (int i = 0; i < aiPrevSelected.length; ++i) {
                ItemDescriptor[] aID = ((TextTableAnd3ButtonGroupDataBean)pb).getFruTableRowAt(aiPrevSelected[i]);
                String sSlctdFruLocSfx = aID[0].getTitle();
                String sSlctdFruDescr = aID[1].getTitle();
                String sSlctdEnclType = aID[2].getTitle();
                String sSlctdEnclModel = aID[3].getTitle();
                String sSlctdEnclSerial = aID[4].getTitle();
                String sSlctdFruLocFull = "U" + sSlctdEnclType + "." + sSlctdEnclModel + "." + sSlctdEnclSerial + "-" + sSlctdFruLocSfx;
                Trace.trace(TRACE_MASKD, "sSlctdFruLocFull = " + sSlctdFruLocFull);
                Trace.trace(TRACE_MASKD, "sSlctdFruDescr = " + sSlctdFruDescr);
                fruListIter = fruList.iterator();
                while (fruListIter.hasNext()) {
                    Fru fruInList = (Fru)fruListIter.next();
                    if (i == 0) {
                        Trace.trace(TRACE_MASKD, "fruInList location = " + (String)fruInList.getProperty("LOCATION"));
                        Trace.trace(TRACE_MASKD, "fruInList descr = " + (String)fruInList.getProperty("DESC"));
                    }
                    if (!((String)fruInList.getProperty("LOCATION")).equals(sSlctdFruLocFull) || !((String)fruInList.getProperty("DESC")).equals(sSlctdFruDescr)) continue;
                    if (isExchange) {
                        fruInList.putProperty("EXCHANGED", new Boolean(true));
                        Trace.trace(TRACE_MASKD, "This FRU was marked exchanged:");
                        Trace.trace(TRACE_MASKD, "fruInList location = " + (String)fruInList.getProperty("LOCATION"));
                        Trace.trace(TRACE_MASKD, "fruInList descr = " + (String)fruInList.getProperty("DESC"));
                        continue block4;
                    }
                    fruInList.putProperty("SELECTED", new Boolean(true));
                    Trace.trace(TRACE_MASKD, "This FRU was marked selected:");
                    Trace.trace(TRACE_MASKD, "fruInList location = " + (String)fruInList.getProperty("LOCATION"));
                    Trace.trace(TRACE_MASKD, "fruInList descr = " + (String)fruInList.getProperty("DESC"));
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterIsolate.displayServiceEffect exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }

    void getFruTableData(Vector vRowData, List fruList, TextTableAnd3ButtonGroupDataBean pb, int[] aiNextSelected) throws EffectorException {
    }

    void addNewFrus(TextTableAnd3ButtonGroupDataBean pb, List fruList, ManagedSystem managedSystem, CommonProblem problem, boolean frusWereExchanged) throws EffectorException {
        int[] aiSelected = pb.getFruTableSelection();
        ArrayList<CommonPaFru> alNewPaFrus = new ArrayList<CommonPaFru>(aiSelected.length);
        for (int i = 0; i < aiSelected.length; ++i) {
            ItemDescriptor[] aID = pb.getFruTableRowAt(aiSelected[i]);
            String sSlctdFruLocSfx = aID[0].getTitle();
            String sSlctdFruDescr = aID[1].getTitle();
            String sSlctdEnclType = aID[2].getTitle();
            String sSlctdEnclModel = aID[3].getTitle();
            String sSlctdEnclSerial = aID[4].getTitle();
            String sSlctdFruLocFull = "U" + sSlctdEnclType + "." + sSlctdEnclModel + "." + sSlctdEnclSerial + "-" + sSlctdFruLocSfx;
            if (i == 0) {
                Trace.trace(TRACE_MASKD, "sSlctdFruLocFull = " + sSlctdFruLocFull);
                Trace.trace(TRACE_MASKD, "sSlctdFruDescr = " + sSlctdFruDescr);
            }
            boolean slctdFruNotInList = true;
            Iterator fruListIter = fruList.iterator();
            while (fruListIter.hasNext()) {
                Fru fruInList = (Fru)fruListIter.next();
                if (i == 0) {
                    Trace.trace(TRACE_MASKD, "fruInList location = " + (String)fruInList.getProperty("LOCATION"));
                    Trace.trace(TRACE_MASKD, "fruInList descr = " + (String)fruInList.getProperty("DESC"));
                }
                if (!((String)fruInList.getProperty("LOCATION")).equals(sSlctdFruLocFull) || !((String)fruInList.getProperty("DESC")).equals(sSlctdFruDescr)) continue;
                slctdFruNotInList = false;
                break;
            }
            if (!slctdFruNotInList) continue;
            CommonPaFru paFru = new CommonPaFru(sSlctdFruDescr, sSlctdFruLocFull, "", "", "", "");
            alNewPaFrus.add(paFru);
            Trace.trace(TRACE_MASKD, "Will add this FRU to list(s):");
            Trace.trace(TRACE_MASKD, "descr = " + sSlctdFruDescr);
            Trace.trace(TRACE_MASKD, "loc = " + sSlctdFruLocFull);
        }
        DefaultFruFilter fruFilter = new DefaultFruFilter(alNewPaFrus);
        List newFrusList = null;
        try {
            newFrusList = managedSystem.filter(fruFilter);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIDriveInfoCenterIsolate.addNewFrus exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
        Iterator newFrusListIter = newFrusList.iterator();
        while (newFrusListIter.hasNext()) {
            Fru newFru = (Fru)newFrusListIter.next();
            fruList.add(newFru);
            Trace.trace(TRACE_MASKD, "Added FRU at location " + (String)newFru.getProperty("LOCATION") + " to fru list.");
            if (!frusWereExchanged) continue;
            CommonPaFru paFru = new CommonPaFru((String)newFru.getProperty("DESC"), (String)newFru.getProperty("LOCATION"), (String)newFru.getProperty("PART_NUM"), (String)newFru.getProperty("SERIAL_NUM"), "", (String)newFru.getProperty("EC_LEVEL"));
            problem.addPart(paFru);
            problem.addReplacedPart(paFru);
            Trace.trace(TRACE_MASKD, "Added FRU at location " + (String)newFru.getProperty("LOCATION") + " to problem part lists.");
        }
    }

    private String makeInfoCenterURL(String infoCenterIsolateName, String ipaddr, Locale locale) {
        Trace.trace(TRACE_MASKT, "-> PIDriveInfoCenterIsolate.makeURL for Isolation procedure: " + infoCenterIsolateName + ", locale:" + locale);
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/iphau/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/iphau/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        if (infoCenterIsolateName == null) {
            Trace.trace(TRACE_MASKF, "PIDriveInfoCenterIsolate.makeURL infocenter target package not set!!! - using default infocenter URL");
            infoCenterIsolateName = "";
        }
        String retUrl = "http://" + ipaddr + correctUrl + infoCenterIsolateName.toLowerCase() + ".htm";
        Trace.trace(TRACE_MASKT, "<- PIDriveInfoCenterIsolate.makeURL: " + retUrl);
        return retUrl;
    }
}

